// ======== ======== ======== ======== ======== ======== ======== ========
//
//	title : |S\vO[ CScene3D.h ]	Auter : KENSUKE WATANABE
//													Data  : 2016/05/30
//
// -------- -------- -------- -------- -------- -------- -------- --------
//Update : 2016/05/30
//
// ======== ======== ======== ======== ======== ======== ======== ========
#ifndef _CSCENE3D_H_
#define _CSCENE3D_H_

#include "main.h"
#include <string>
#include "scene.h"

// -------- -------- -------- -------- -------- -------- -------- --------
// 萔`
// -------- -------- -------- -------- -------- -------- -------- --------
// _tH[}bg
#define FVF_VERTEX_3D (D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_DIFFUSE | D3DFVF_TEX1)	//_tH[}bg	DIFFUSE:F TEX1:eNX`W(UVST)

// -------- -------- -------- -------- -------- -------- -------- --------
// \̐錾
// -------- -------- -------- -------- -------- -------- -------- --------
typedef struct
{// _\
	D3DXVECTOR3 pos;	// _W
	D3DXVECTOR3 nom;	// @W
	D3DCOLOR col;		// F
	D3DXVECTOR2 tex;	// UV
}VERTEX_3D;

// -------- -------- -------- -------- -------- -------- -------- --------
// NX
// -------- -------- -------- -------- -------- -------- -------- --------
class CScene3D : public CScene
{
public:
	CScene3D(int priority = 4);
	~CScene3D();

	void Init(void) {}
	void Uninit(void) {}
	void Update(void) {}
	void Draw(void) {}

	const D3DXMATRIX &GetMtxWorld()const { return m_mtxWorld; }
	const int &GetR()const { return m_r; }
	const int &GetG()const { return m_g; }
	const int &GetB()const { return m_b; }
	const int &GetA()const { return m_a; }
	void SetCol(const int &r, const int &g, const int &b, const int &a) { m_r = r; m_g = g; m_b = b; m_a = a; }
	void AddCol(const int &r, const int &g, const int &b, const int &a) { m_r += r; m_g += g; m_b += b; m_a += a; }

	void SetNumVtx(const int &numVtx) { m_numVtx = numVtx; }
	void SetNumIndex(const int &numIndex) { m_numIndex = numIndex; }
	const int &GetNumVtx(void) { return m_numVtx; }
	const int &GetNumIndex(void) { return m_numIndex; }

protected:
	std::string m_strFilePass;		// eNX`FilePass
	D3DXMATRIX m_mtxWorld;			// [h}gNX
	LPDIRECT3DINDEXBUFFER9 m_pIdxBuffer;
private:
	int m_numVtx;
	int m_numIndex;
	int m_r, m_g, m_b, m_a;
};

#endif
